#ifndef _CEGOLOGTHREAD_H_INCLUDED_
#define _CEGOLOGTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogThread.h  
// -----------------
// Cego log thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoLogThread
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoLogHandler.h"
#include "CegoLockHandler.h"
#include "CegoDatabaseManager.h"

class CegoLogThreadPool;

class CegoLogThread : public Thread {
    
 public:

    CegoLogThread();
    CegoLogThread(CegoLogThreadPool *pPool, CegoDatabaseManager *pDBMng);
    ~CegoLogThread();

    const Chain& lastAction() const;
    void* job(void* arg);

    bool isTerminated();

 private:

    void serveSession(CegoLogHandler *pLH);

    long _idx;

    CegoDatabaseManager* _pDBMng;
    CegoLogThreadPool* _pPool;
    NetHandler* _pRequest;

    Chain _lastAction;

    NanoTimer* _pTim;

    unsigned long _modId;
};

#endif














