#ifndef _CEGOLOGTHREADPOOL_H_INCLUDED_
#define _CEGOLOGTHREADPOOL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogThreadPool.h  
// ---------------------
// Cego log threadpool class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoLogThreadPool
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Logger.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoLogThread.h"

class CegoLogThread;

class CegoLogThreadPool : public Thread {
    
 public:

    enum ThreadState { READY, BUSY, CONNECTED };
  
    CegoLogThreadPool();
    CegoLogThreadPool(CegoDatabaseManager *pDBMng);
    CegoLogThreadPool(int poolLimit, CegoDatabaseManager *pDBMng);
    ~CegoLogThreadPool();

    int getPoolLimit() const;
    void* job(void* arg);

    void getThreadInfo(long i, long& numRequest, long& threadLoad, ThreadState& state, Chain& action);
    void setState(long i, ThreadState state);
    void setTid(long i, long tid);
    void incNumRequest(long i);

    void addThreadIdle(long i, long usec);

    void dispatch();

    NetHandler* nextRequest();

    bool isTerminated();
    
    void getLockStat(Chain& lockName, long& lockCount, long &numRdLock, long &numWrLock, long &sumRdDelay, long &sumWrDelay);

 private:

    void copyLog(const Chain& tableSet, const Chain& logFileName, const Chain& archLogPath);
    void shiftRedoLogs();
    void lockQueue();
    void unlockQueue();
	
    long* _threadId;
    long* _numRequest;
    ThreadState* _threadState;

    long* _threadIdle[THRMNG_NUMLOADSAMPLE];
    long* _threadLoad;
    int _samplePos;

    CegoLogThread** _threadList;
    

    int _poolLimit;
    Chain _logHostName;
    int _logPortNo;

    bool _terminated;
    bool _joined;

    ListT<NetHandler*> _requestQueue;

    CegoDatabaseManager* _pDBMng;

    unsigned long _modId;
};

#endif














