///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoModule.cc
// -------------
// Cego module implementation
//     
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoModule
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>

// cego includes
#include "CegoModule.h"

const char *CEGO_MODULE_MAP[] =
{
    "None",
    "CegoMain",
    "CegoLogThread",
    "CegoDbThread",
    "CegoAction",
    "CegoDbHandler",
    "CegoSelect",
    "CegoXPorter",
    "CegoTableManager",
    "CegoTableCursor",
    "CegoObjectManager",
    "CegoSystemObject",
    "CegoBufferPool",
    "CegoLogManager",
    "CegoLogHandler",
    "CegoAdminThread",
    "CegoObjectCursor",
    "CegoAVLIndexManager",
    "CegoImpInStream",
    "CegoExpOutStream",
    "CegoFileHandler",
    "CegoDatabaseManager",
    "CegoMediatorThread",
    "CegoDistManager",
    "CegoRecoveryManager",
    "CegoDbThreadPool",
    "CegoLogThreadPool",
    "CegoAdminThreadPool",
    "CegoBeatThread",
    "CegoBeatConnection",
    "CegoDistDbHandler",
    "CegoDistCursor",
    "CegoAdminHandler",
    "CegoTransactionManager",
    "CegoLockHandler",
    "CegoBTreeManager",
    // just for client programs
    "CegoClient",
    "CegoAdmin",
    "CegoAdmAction",
    "cgwrap"
};


CegoModule::CegoModule() : Logger()
{
}

CegoModule::CegoModule(const Chain& logFile) : Logger(logFile)
{
}

CegoModule::~CegoModule()
{
}

int CegoModule::getModId(const Chain& module)
{
    int i=0;
    while ( i < sizeof (  CEGO_MODULE_MAP ) / sizeof( char*) )
    {
	if ( Chain( CEGO_MODULE_MAP[i] ) == module )
	    return i;
	i++;
    }
    throw Exception(EXLOC, Chain("Module ") + module + Chain(" not registered"));
}

Chain CegoModule::getModName(int id)
{
    return Chain( CEGO_MODULE_MAP[id] );
}

int CegoModule::getMapSize()
{
    return sizeof(CEGO_MODULE_MAP) / sizeof(char*);
}



