#ifndef _CEGONET_H_INCLUDED_
#define _CEGONET_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoNet.h
// ---------
// Cego net client API
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoNet
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoField.h"
#include "CegoDbHandler.h"

class CegoNet {

 public:

    CegoNet(CegoDbHandler::ProtocolType protType, const Chain& logFile, const Chain& logMode );
    ~CegoNet();
    
    void connect(const Chain& serverName, int port, const Chain& tableSet, const Chain& user, const Chain& pwd);
    long doQuery(const Chain& query);
    bool fetchData(const ListT<CegoField>& schema, ListT<CegoFieldValue>& fvl);

    bool isFetchable();
    void abortQuery();
    void resetQuery();
    bool wasReset();
    
    const Chain& getMsg();
    long getAffected();
    void getSchema(ListT<CegoField>& schema);
    void getProcResult(ListT<CegoProcVar>& outParamList, CegoFieldValue& retValue);


    void disconnect();

private:

    CegoDbHandler::ProtocolType _protType;
    Chain _logFile;
    Chain _logMode;

    NetHandler* _pN;
    CegoDbHandler* _pSH;
    CegoModule* _pModule;

    bool _isFetchable;
};

#endif




