#ifndef _CEGOOBJECT_H_INCLUDED_
#define _CEGOOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoObject.h
// ------------
// Cego object super class class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoObject
// 
// Description: Cego super class structure
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

class CegoObject {

 public:

    enum ObjectType { SYSTEM, 
		      TABLE,
		      PINDEX,
		      UINDEX,
		      INDEX,		      
		      VIEW,
		      RBSEG,
		      FKEY,
		      PROCEDURE,
		      CHECK,
		      JOIN,
		      PBTREE,
		      UBTREE,
		      BTREE,
		      UNDEFINED};

    CegoObject();
    CegoObject(const CegoObject& oe);
    CegoObject(ObjectType type,  const Chain& objName, int tabSetId = 0);

    ~CegoObject();
    
    void setName(const Chain& name);
    const Chain& getName() const;

    void setType(ObjectType type);
    ObjectType getType() const;

    void setTabSetId(int tabSetId);
    int getTabSetId() const;

    int getBaseSize() const;
    void encodeBase(char *buf, int entrySize);
    void decodeBase(char *buf, int& entrySize);
            
    CegoObject& operator = ( const CegoObject& oe);
    bool operator == ( const CegoObject& oe);

    Chain toChain() const;

 private:

    ObjectType _type;
    Chain _name;
    int _tabSetId;

};

#endif
