#ifndef _CEGOOBJECTCURSOR_H_INCLUDED_
#define _CEGOOBJECTCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoObjectCursor.h
// ------------------
// Cego object cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoObjectCursor
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoLockHandler.h"
#include "CegoObjectManager.h"
#include "CegoDataPointer.h"

class CegoObjectManager;

class CegoObjectCursor {
    
public:
    
    CegoObjectCursor();
    CegoObjectCursor(CegoBufferPool *pOM, CegoLockHandler *pLockHandle, 
		     int tabSetId, 
		     CegoObject::ObjectType type,
		     int fileId, int pageId);
    ~CegoObjectCursor();
    
    void* getFirst(int& len, CegoDataPointer& dp);
    void* getNext(int& len, CegoDataPointer& dp);
    
    void abort();
    void reset();

    int getTabSetId();

 private:
    
    CegoBufferPool* _pBufPool;
    CegoLockHandler* _pLockHandle;
    CegoBufferPage _bp;
    

    CegoObject::ObjectType _type;
    int _tabSetId;
    int _fileId;
    int _pageId;

    unsigned long _lockId;
    unsigned long _recLock;

    bool _isEOC;

    int _startFileId;
    int _startPageId;


    unsigned long _modId;
};

#endif
