#ifndef _CEGOORDERCURSOR_H_INCLUDED_
#define _CEGOORDERCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderCursor.h
// ------------------
// Cego order cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoOrderCursor
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// lfc include
#include <lfcbase/AVLTreeT.h>

// cego includes
#include "CegoTableManager.h"
#include "CegoDataPointer.h"
#include "CegoOrderNode.h"

class CegoOrderCursor {
    
public:
    
    CegoOrderCursor(AVLTreeT<CegoOrderNode>* pAVL);
    ~CegoOrderCursor();
    
    bool getFirst(ListT<CegoField>& fl);
    bool getNext(ListT<CegoField>& fl);
    
    void abort();

 private:

    AVLTreeT<CegoOrderNode>* _pAVL;

    // bool getMostLeft(ListT<CegoField>& fl);
    
};

#endif
