///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderNode.cc
// ----------------
// Cego order node class implementation
//     
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoOrderNode
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>

// cego includes
#include "CegoOrderNode.h"

#include <string.h>
#include <stdlib.h>

CegoOrderNode::CegoOrderNode()
{
}

CegoOrderNode::CegoOrderNode(ListT<CegoFieldValue>& key, ListT<CegoField>& tuple, ListT<Ordering>* pOrdering)
{
    _key = key;
    _tuple = tuple;
    _pOrdering = pOrdering;
}

CegoOrderNode::~CegoOrderNode()
{
}

ListT<CegoFieldValue>& CegoOrderNode::getKey()
{
    return _key;
}

ListT<CegoField>& CegoOrderNode::getTuple()
{
    return _tuple;
}


CegoOrderNode& CegoOrderNode::operator = ( const CegoOrderNode& n)
{
    _key = n._key;
    _tuple = n._tuple;
    _pOrdering = n._pOrdering;
    return (*this);
}

bool CegoOrderNode::operator == ( const CegoOrderNode& n)
{
    Ordering *pOrd = _pOrdering->First();
    CegoFieldValue* pFV1 = _key.First();
    CegoFieldValue* pFV2 = n._key.First();

    while ( pOrd && pFV1 && pFV2 )
    {
	if ( *pFV1 < *pFV2 )
	{
	    return false;
	}
	else if ( *pFV1 > *pFV2 )
	{
	    return false;
	}

	pOrd = _pOrdering->Next();
	pFV1 = _key.Next();
	pFV2 = n._key.Next();
    }

    return true;

}

bool CegoOrderNode::operator > ( const CegoOrderNode& n)
{    
    Ordering *pOrd = _pOrdering->First();

    CegoFieldValue* pFV1 = _key.First();
    CegoFieldValue* pFV2 = n._key.First();

    while ( pOrd && pFV1 && pFV2 )
    {
	if ( *pFV1 < *pFV2 )
	{
	    if ( *pOrd == ASC )
		return false;
	    else
		return true;
	}
	else if ( *pFV1 > *pFV2 )
	{
	    if ( *pOrd == ASC )
		return true;
	    else
		return false;
	}

	pOrd = _pOrdering->Next();
	pFV1 = _key.Next();
	pFV2 = n._key.Next();
    }

    return false;
}

bool CegoOrderNode::operator < ( const CegoOrderNode& n)
{

    Ordering *pOrd = _pOrdering->First();
    CegoFieldValue* pFV1 = _key.First();
    CegoFieldValue* pFV2 = n._key.First();

    while ( pOrd && pFV1 && pFV2 )
    {
	if ( *pFV1 < *pFV2 )
	{
	    if ( *pOrd == ASC )
		return true;
	    else
		return false;
	}
	else if ( *pFV1 > *pFV2 )
	{
	    if ( *pOrd == ASC )
		return false;
	    else
		return true;
	}

	pOrd = _pOrdering->Next();
	pFV1 = _key.Next();
	pFV2 = n._key.Next();
    }

    return false;
}



