#ifndef _CEGOORDERSPACE_H_INCLUDED_
#define _CEGOORDERSPACE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderSpace.h
// -----------------
// Cego order space class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoOrderSpace
// 
// Description: Cego order space
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDefs.h"
#include "CegoAttrDesc.h"
#include "CegoOrderNode.h"
#include "CegoOrderCursor.h"
#include "CegoQueryHelper.h"

// forward declaration
class CegoTableManager;

class CegoOrderSpace {
    
 public:

    CegoOrderSpace();
    ~CegoOrderSpace();
       
    void initOrderSpace(ListT<CegoExpr*> *pOrderList, ListT<CegoOrderNode::Ordering> *pOrderOptList, long maxOrderSize);
    void insertTuple(ListT<CegoField>& orderKey, ListT<CegoField>& orderTuple);

    void resetOrderSpace();

    CegoOrderCursor* getCursor();

    long numAllocated() const;
 
 private:

    AVLTreeT<CegoOrderNode>* _pAVL;

    void setAggregationValue(CegoExpr *pExpr, ListT<CegoField>& fl);

    ListT<CegoExpr*>* _pOrderList;
    ListT<CegoOrderNode::Ordering>* _pOrderOptList;
    ListT<CegoField> _orderSchema;

    long _maxOrderSize;
    long _orderSize;

};

#endif




