#ifndef _CEGOOUTPUT_H_INCLUDED_
#define _CEGOOUTPUT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOutput.h
// ------------
// Cego formatting data for output
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoOutput
// 
// Description: The CegoOutput class converts query output to an appropriate format.
//              This may either be XML-based style for serving a client request or 
//              ascii-based tableformat for batchmode or client-side output
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoProcVar.h"
#include "CegoContentObject.h"
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoDbHandler.h"

class CegoOutput {

 public:

    CegoOutput();
    CegoOutput(const ListT<CegoField>& schema, const Chain& format = Chain(""));
    ~CegoOutput();
    
    void objectInfo(CegoDecodableObject& co);
    void setDbHandle(CegoDbHandler* pDbHandle, int rowsPerMsg = 0);
    void setRawMode(bool isOn);
    void headOut();
    void rowOut(const ListT<CegoField>& fl);    
    void rowOut(const ListT<CegoFieldValue>& fl);
    void tailOut();
    void tabOut(const ListT< ListT<CegoFieldValue> >& fa);
    void abort(const Chain& msg);
    void chainOut(const Chain& msg, long affCount = 0);
    void procResultOut(const Chain& msg, const ListT<CegoProcVar>& outParamList, CegoFieldValue *pRetVal);

 private:

    int maxFieldSize(CegoField *pF);
    int max(int i1, int i2, int i3, int i4);
    Chain fill(const Chain& s, int num);
    Chain formatCell(int i, const Chain& s, int maxLen);

    CegoDbHandler* _pDbHandle;

    ListT<CegoField> _schema;

    int _rowCount;
    int _rowsPerMsg;
    int _preFill;

    bool _rawMode;
    Chain _format;
};

#endif


