///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcAssignStmt.cc  
// ---------------------                                                     
// Cego procedure assign statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcAssignStmt
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcAssignStmt.h"

CegoProcAssignStmt::CegoProcAssignStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _mode = EXPR2NULL;
    _pExpr = pExpr;
    _pExpr->setBlock(pBlock);
}

CegoProcAssignStmt::CegoProcAssignStmt(const Chain& paramName,
				       CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _mode = EXPR2PARAM;
    _paramName = paramName;
    _pExpr = pExpr;
    _pExpr->setBlock(pBlock);
}

CegoProcAssignStmt::~CegoProcAssignStmt()  
{
    if ( _pExpr )
    {
	delete _pExpr;    
    }
}

CegoException CegoProcAssignStmt::execute()
{    
    switch ( _mode )
    {
    case CegoProcAssignStmt::EXPR2NULL:
    {
	CegoFieldValue fv;
	fv = _pExpr->evalFieldValue();
	break;
    }
    case CegoProcAssignStmt::EXPR2PARAM:
    {
	setValue(_paramName, _pExpr->evalFieldValue());
	break;
    }
    }
    return NONE_EXCEP;
}

Chain CegoProcAssignStmt::toChain(const Chain& indent) const
{

    switch ( _mode )
    {
    case CegoProcAssignStmt::EXPR2NULL:
    {
	Chain s;
	s =  indent + _pExpr->toChain();
	return s;
    }
    case CegoProcAssignStmt::EXPR2PARAM:
    {
	Chain s;
	s = indent + Chain(":")  + _paramName + " = " + _pExpr->toChain();
	return s;
    }
    }
}
