#ifndef _CEGOPROCBLOCK_H_INCLUDED_
#define _CEGOPROCBLOCK_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcBlock.h  
// ---------------
// Cego proc block class definition
// 
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcBlock
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// base includes
#include "CegoException.h"
#include "CegoProcStmt.h"
#include "CegoProcVar.h"
#include "CegoProcCursor.h"

class CegoProcException;
class CegoProcStmt;

class CegoProcBlock  {
    
public:
    
    CegoProcBlock(CegoProcBlock *pParentBlock);
    ~CegoProcBlock();

    void setVarList(const ListT<CegoProcVar>& varList);
    ListT<CegoProcVar>& getVarList();

    void addCursor(const Chain& cursorName, CegoSelect *pSelect);
    CegoProcCursor* getCursor(const Chain& cursorName);

    void setValue(const Chain& varName, const CegoFieldValue& fv);
    CegoFieldValue getValue(const Chain& varName);

    void addStatement(CegoProcStmt* pS);    
    void addException(CegoProcException* pE);

    CegoException execute();

    void setParentBlock(CegoProcBlock* pParentBlock);
    CegoProcBlock* getParentBlock();

    Chain toChain(const Chain& indent = Chain("")) const;

    void setRetVal(const CegoFieldValue& retVal);
    CegoFieldValue& getRetVal();

    void setExceptionMsg(const Chain msg);
    Chain getExceptionMsg() const;
    
    ListT<CegoProcStmt*>& getStmtList();
    const ListT<CegoProcException*>& getExceptionList() const;
    
private:

    void cleanBlock();
    void closeBlock();    

    CegoProcBlock* _pParentBlock;

    ListT<CegoProcStmt*> _stmtList;
    ListT<CegoProcVar> _varList;
    ListT<CegoProcCursor*> _cursorList;

    ListT<CegoProcException*> _exceptionList;

    CegoFieldValue _retVal;

    Chain _exceptionMsg;
};

#endif














