///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcBlockStmt.cc  
// --------------------
// Cego procedure statement block class implementation
//               
// Design and Implementation by Bjoern Lemke
//                                   
// (C)opyright 2000-2010 Bjoern Lemke                  
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProBlockStmt
// 
// Description: see header file for description
//
// Status: QG-2.6
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcBlockStmt.h"
#include "CegoProcException.h"

CegoProcBlockStmt::CegoProcBlockStmt(CegoProcBlock *pBlock, CegoProcBlock *pParentBlock) : CegoProcStmt(pParentBlock)
{
    _pBlock = pBlock;
}

CegoProcBlockStmt::~CegoProcBlockStmt()  
{
    if ( _pBlock )
	delete _pBlock;
}

void CegoProcBlockStmt::setBlock(CegoProcBlock * pBlock)
{
    _pBlock = pBlock;
}

CegoException CegoProcBlockStmt::execute()
{

    CegoException result;
    result =  _pBlock->execute();
    if ( result != NONE_EXCEP )
	return result;
    
    return NONE_EXCEP;
}

Chain CegoProcBlockStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = indent + Chain("begin\n");
    s += _pBlock->toChain(indent + indent);

    CegoProcException **pException = _pBlock->getExceptionList().First();
    while ( pException ) 
    {
	s += indent + Chain("exception when ") + (*pException)->toChain() + Chain(" then \n");	
	s += (*pException)->getBlock()->toChain(indent + indent);
	pException = _pBlock->getExceptionList().Next();
    }

    s += indent + Chain("end");
    return s;
}
