#ifndef _CEGOPROCCOND_H_INCLUDED_
#define _CEGOPROCCOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCond.h  
// --------------
// Cego procedure condition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcCond
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcPred.h"
#include "CegoProcStmt.h"

class CegoProcPred;

class CegoProcCond  {
    
public:
    
    enum ConditionMode { AND , OR, PRED };
    
    CegoProcCond();

    CegoProcCond(CegoProcCond* pCond, CegoProcPred *pPred, ConditionMode mode);
    CegoProcCond(CegoProcPred *pPred);

    ~CegoProcCond();

    void setBlock(CegoProcBlock *pBlock);

    bool eval() const;

    CegoProcCond& operator = (const CegoProcCond& c);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoProcCond& c);
    
private:

    ConditionMode _mode;
    CegoProcCond* _pCond;
    CegoProcPred* _pPred;
    
};

#endif














