///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursor.cc
// ----------------
// Cego stored procedure cursor 
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcCursor
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcCursor.h"
#include "CegoSelect.h"

CegoProcCursor::CegoProcCursor()
{
    _pSelect = 0;
}

CegoProcCursor::CegoProcCursor(const CegoProcCursor& pc)
{
    _name = pc._name;
    _pSelect = pc._pSelect;
    _status = pc._status;
}

CegoProcCursor::CegoProcCursor(const Chain& name)
{
    _name = name;
    _pSelect = 0;
    _status = CLOSED;
}

CegoProcCursor::CegoProcCursor(const Chain& name, CegoSelect *pSelect)
{
    _name = name;
    _pSelect = pSelect;
    _status = CLOSED;
}

CegoProcCursor::~CegoProcCursor()
{
    if ( _pSelect )
	delete _pSelect;
}
   
void CegoProcCursor::setName(const Chain& name)
{
    _name = name;
}
 
const Chain& CegoProcCursor::getName() const
{
    return _name;
}
    
void CegoProcCursor::setSelect(CegoSelect* pSelect)
{
    _pSelect = pSelect;
}

CegoSelect* CegoProcCursor::getSelect() const
{
    return _pSelect;
}

void CegoProcCursor::open()
{

    if ( _pSelect )
    {
	_pSelect->prepare();	
	_status = OPEN;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}

void CegoProcCursor::close()
{

    if ( _pSelect )
    {
	_pSelect->cleanUp();
	_status = CLOSED;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}

void CegoProcCursor::reset()
{

    if ( _pSelect )
    {
	_pSelect->reset(true);
	_status = CLOSED;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}

bool CegoProcCursor::nextTuple(ListT<CegoField>& fl)
{

    if ( _status == CLOSED  )
	open();

    if ( _pSelect )
    {
	bool retVal = _pSelect->nextTuple(fl);
	if ( retVal == false )
	    _status = CLOSED;
	return retVal;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}
        
CegoProcCursor& CegoProcCursor::operator = ( const CegoProcCursor& pc)
{
    _name = pc._name;
    _pSelect = pc._pSelect;
    _status = pc._status;
    return (*this);
}
    
bool CegoProcCursor::operator == ( const CegoProcCursor& pc)
{
    if ( _name == pc._name )
	return true;
    return false;
}

Chain CegoProcCursor::toChain() const
{
    Chain s;
    s = _name;
    return s;
}

ostream& operator << (ostream& s, const CegoProcCursor& pc)
{    
    s <<  pc._name;
    return s;
}
