#ifndef _CEGOPROCCURSOR_H_INCLUDED_
#define _CEGOPROCCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursor.h
// ----------------
// Cego stored procedure cursor 
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcCursor
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoField.h"

class CegoSelect;

class CegoProcCursor {

 public:

    enum CursorStatus { CLOSED, OPEN };

    CegoProcCursor();
    CegoProcCursor(const CegoProcCursor& pc);
    CegoProcCursor(const Chain& name);
    CegoProcCursor(const Chain& name, CegoSelect *pSelect);
    ~CegoProcCursor();
    
    void setName(const Chain& name);
    const Chain& getName() const;
    
    void setSelect(CegoSelect *pSelect);
    CegoSelect* getSelect() const;

    void open();
    void reset();

    void close();

    bool nextTuple(ListT<CegoField>& fl);
        
    CegoProcCursor& operator = ( const CegoProcCursor& pp);
    bool operator == ( const CegoProcCursor& pp);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoProcCursor& pp);
    
private:
    
    Chain _name;
    CegoSelect* _pSelect;
    CursorStatus _status;
    
};

#endif




