///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursorCreateStmt.cc  
// ---------------------------                                                     
// Cego procedure cursor statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcCursorCreateStmt
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>

// cego includes
#include "CegoSelect.h"
#include "CegoProcCursorCreateStmt.h"

CegoProcCursorCreateStmt::CegoProcCursorCreateStmt(const Chain& name, CegoSelect *pSelect,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _name = name;
    _pSelect = pSelect;
}

CegoProcCursorCreateStmt::~CegoProcCursorCreateStmt()  
{
}

CegoException CegoProcCursorCreateStmt::execute()
{
    if ( _pSelect )
    {
	_pSelect->setProcBlock(getParentBlock());
	_pSelect->prepare();	
    }
    return NONE_EXCEP;
}

Chain CegoProcCursorCreateStmt::toChain(const Chain& indent) const
{
    Chain s;

    s += indent + Chain("cursor ");
    s += _name;
    s += Chain(" as\n");
    s += _pSelect->toChain(indent + indent);
    return s;
}
