///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcException.cc
// --------------------
// Cego procedure exception container class
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcException
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoDefs.h"
#include "CegoProcException.h"

CegoProcException::CegoProcException(CegoException excep, CegoProcBlock *pBlock, CegoProcBlock *pParentBlock) : CegoProcStmt(pParentBlock)
{
    _excep = excep;
    _pBlock = pBlock;
}

CegoProcException::~CegoProcException()
{
}
    
CegoException CegoProcException::getException() const
{
    return _excep;
}

CegoProcBlock* CegoProcException::getBlock()
{
    return _pBlock;
}

CegoException CegoProcException::execute()
{
    return NONE_EXCEP;
}

CegoProcException& CegoProcException::operator = ( const CegoProcException& pe)
{
    _excep = pe._excep;
    _pBlock = pe._pBlock;
    return (*this);
}

bool CegoProcException::operator == ( const CegoProcException& pe)
{
    if ( _excep == pe._excep )
	return true;
    return false;
}

Chain CegoProcException::toChain(const Chain& indent) const
{
    Chain s = indent;

    if ( _excep == INVALID_OBJECT_EXCEP )
    {
	s += Chain(INVALID_OBJECT_EXCEP_ID);
    }
    else if ( _excep == INVALID_ATTRIBUTE_EXCEP )
    {
	s += Chain(INVALID_ATTRIBUTE_EXCEP_ID);
    }
    else if ( _excep == COREOP_EXCEP ) 
    {
	s += Chain(COREOP_EXCEP_ID);
    }
    else if ( _excep == ANY_EXCEP ) 
    {
	s += Chain(ANY_EXCEP_ID);
    }
    else
    {
	s += Chain(OTHER_EXCEP_ID);
    }

    return s;
}
    
ostream& operator << (ostream& s, const CegoProcException& pe)
{    
    s << pe.toChain();
    return s;
}
