#ifndef _CEGOPROCEXCEPTION_H_INCLUDED_
#define _CEGOPROCEXCEPTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcException.h
// -------------------
// Cego procedure exception container class
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcException
// 
// Description: data structure description for cego procedure parameters
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"

class CegoProcException : public CegoProcStmt {

public:
  
    CegoProcException(CegoException type, CegoProcBlock *pBlock, CegoProcBlock *pParentBlock);
    ~CegoProcException();
    
    CegoException getException() const;
    CegoProcBlock* getBlock();

    CegoProcException& operator = ( const CegoProcException& pe);
    bool operator == ( const CegoProcException& pe);

    CegoException execute();

    Chain toChain(const Chain& indent = Chain("")) const;
    friend ostream& operator << (ostream& s, const CegoProcException& pe);
    
private:
    
    CegoException _excep;
    CegoProcBlock* _pBlock;
    
};

#endif




