///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcFetch.cc
// ----------------
// Cego procedure fetch structure class definition
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcFetch
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcFetch.h"

CegoProcFetch::CegoProcFetch()
{
}

CegoProcFetch::CegoProcFetch(CegoProcCursor *pCur, const ListT<Chain>& varList)
{
    _pCur = pCur;
    _varList = varList;
}

CegoProcFetch::~CegoProcFetch()
{
}

CegoProcFetch& CegoProcFetch::operator = ( const CegoProcFetch& pf)
{
    _pCur = pf._pCur;
    _varList = pf._varList;
    return (*this);
}

void CegoProcFetch::setBlock(CegoProcBlock *pBlock)
{
    _pBlock = pBlock;
}

bool CegoProcFetch::fetch()
{
    ListT<CegoField> fvl;

    bool moreTuple;
    
    moreTuple = _pCur->nextTuple(fvl);
    
    if ( moreTuple )
    {
	CegoField *pF = fvl.First();

	Chain *pVar = _varList.First();
	while ( pVar && pF )
	{
	    _pBlock->setValue(*pVar, pF->getValue());
	    pVar = _varList.Next();
	    pF = fvl.Next();
	}

	/*
	CegoProcVar **pVar = _varList.First();
	while ( pVar && pF )
	{
	    (*pVar)->setValue(pF->getValue());
	    pVar = _varList.Next();
	    pF = fvl.Next();
	}
	*/

    }
    
    return moreTuple;
}

Chain CegoProcFetch::toChain() const
{
    Chain s;

    s = Chain("fetch ") + _pCur->getName() + Chain(" into (");
   	
    Chain *pVar = _varList.First();
    while ( pVar )
    {
	s += Chain(":") + *pVar;
	pVar = _varList.Next();
	if ( pVar )
	    s += Chain(", ");
    }
    s += Chain(")");
    return s;
}

ostream& operator << (ostream& s, const CegoProcFetch& pf)
{    
    return s;
}
