///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcIfStmt.cc  
// -----------------    
// Cego procedure if statement class implementation
//                                                 
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcIfStmt
// 
// Description: 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoProcIfStmt.h"

CegoProcIfStmt::CegoProcIfStmt(ListT<CegoProcCond*>& condList,
				   ListT<CegoProcBlock*>& ifBlockList,
				   CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _condList = condList;
    _ifBlockList = ifBlockList;
}

CegoProcIfStmt::~CegoProcIfStmt()  
{
    CegoProcCond** pCond = _condList.First();
    
    while  ( pCond )
    {
	delete *pCond;
	pCond = _condList.Next();
    }

    CegoProcBlock** pBlock = _ifBlockList.First();
    while ( pBlock )
    {
	delete *pBlock;
	pBlock = _ifBlockList.Next();
    }
  
}

CegoException CegoProcIfStmt::execute()
{

    
    CegoProcCond** pCond = _condList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    while ( pCond )
    {
	
	(*pCond)->setBlock(getParentBlock());
	
	if ( (*pCond)->eval() == true )
	{
	    return (*pBlock)->execute();		
	}
	else
	{
	    pCond = _condList.Next();
	    pBlock = _ifBlockList.Next();
	}
    }
    
    if ( pBlock )
    { 
	return (*pBlock)->execute();
    }
    
    return NONE_EXCEP;
}

Chain CegoProcIfStmt::toChain(const Chain& indent) const
{

    Chain s;

    CegoProcCond** pCond = _condList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    s = indent + Chain("if ");
    
    while ( pCond )
    {
	
	s += (*pCond)->toChain();
	
	s += Chain("\n") + indent + Chain("then\n");
	    
	s += (*pBlock)->toChain(indent + indent);
	
	pCond = _condList.Next();
	pBlock = _ifBlockList.Next();
	if ( pCond )
	    s += indent + Chain("elsif ");
	else if ( pBlock == 0 )
	    s += indent + Chain("end");
    }
    if ( pBlock )
    {
	s += indent + Chain("else\n");
	s += indent + (*pBlock)->toChain();
	s += indent + Chain("end");
    }

    return s;
}
