#ifndef _CEGOPROCOBJECT_H_INCLUDED_
#define _CEGOPROCOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcObject.h
// ----------------
// Cego procedure object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcObject
// 
// Description: Container class for Cego stored procedures
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// xml includes
#include <lfcxml/Element.h>

// cego includes
#include "CegoField.h"
#include "CegoDecodableObject.h"

class CegoProcObject : public CegoDecodableObject {

 public:

    CegoProcObject();
    CegoProcObject(const CegoProcObject& ko);
    CegoProcObject(const Chain& procName, int tabSetId = 0);

    CegoProcObject(int tabSetId, const Chain& procName, const Chain& procText);
	
    ~CegoProcObject();
    
    int getEntrySize() const;

    void encode(char *buf);
    void decode(char *buf);

    const Chain& getProcText() const;

    void setEmpty();
    
    CegoProcObject& operator = ( const CegoProcObject& oe);
    bool operator == ( const CegoProcObject& oe);
    
    Chain toChain() const;

    Element* getElement() const;
    void putElement(Element* pElement);
    Chain getFormatted() const;

 private:

    Chain _procText;
    Chain fill(const Chain& s, int num) const;
};

#endif
