#ifndef _CEGOPROCPRED_H_INCLUDED_
#define _CEGOPROCPRED_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcPred.h  
// --------------
// Cego procedure predicate class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcPred
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoComparison.h"
#include "CegoProcCond.h"
#include "CegoExpr.h"

class CegoProcCond;

class CegoProcPred  {
    
public:
    
    enum PredicateMode { EXPRCOMP, NULLCOMP, CONDITION };
    
    CegoProcPred();

    CegoProcPred(CegoExpr* pExpr1, CegoExpr* pExpr2, CegoComparison comp);
    CegoProcPred(CegoExpr* pExpr1, bool isNegate);
    CegoProcPred(CegoProcCond *pCond);
    ~CegoProcPred();

    void setBlock(CegoProcBlock *pBlock);
    bool eval() const;
    Chain toChain() const;

    CegoProcPred& operator = (const CegoProcPred& c);
    friend ostream& operator << (ostream& s, const CegoProcPred& p);
    
private:

    PredicateMode _mode;
    CegoExpr *_pExpr1;
    CegoExpr *_pExpr2;
    CegoProcCond* _pCond;
    CegoComparison _comp;
    bool _isNegate;

};

#endif














