///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcQueryStmt.cc  
// --------------------                                                     
// Cego procedure query statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcQueryStmt
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego include
#include "CegoQueryException.h"
#include "CegoProcQueryStmt.h"
#include "CegoExpr.h"

CegoProcQueryStmt::CegoProcQueryStmt(CegoQuery *pQuery,
				     CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pQuery = pQuery;
}

CegoProcQueryStmt::~CegoProcQueryStmt()  
{
    delete _pQuery;
}

CegoException CegoProcQueryStmt::execute()
{
    
    _pQuery->setBlock(getParentBlock());    
    
    try 
    {
	Chain msg = _pQuery->execute(getParentBlock());
    }
    catch ( CegoQueryException qe ) 
    {
	CegoProcBlock *pBlock = getParentBlock();
	if ( pBlock )
	{
	    Chain excepMsg = Chain("Procedure query error");
	    Chain msg;
	    while ( qe.pop(msg) )
	    {
		excepMsg += Chain("\n -> ") + msg;
	    }
	    pBlock->setExceptionMsg(excepMsg);
	}
	
	return qe.getException();
    }
    return NONE_EXCEP;
}

Chain CegoProcQueryStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = _pQuery->toChain(indent);
    return s;
}
