///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcReturnStmt.cc  
// ---------------------                                                     
// Cego procedure return statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcReturnStmt
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcReturnStmt.h"

CegoProcReturnStmt::CegoProcReturnStmt(CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = 0;
}

CegoProcReturnStmt::CegoProcReturnStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = pExpr;
}

CegoProcReturnStmt::~CegoProcReturnStmt()  
{
    if ( _pExpr )
	delete _pExpr;
}

CegoException CegoProcReturnStmt::execute()
{
    if ( _pExpr )
    {
	_pExpr->setBlock(getParentBlock());
	getParentBlock()->setRetVal(_pExpr->evalFieldValue());
    }
    return RETURN_EXCEP;
}

Chain CegoProcReturnStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = indent + Chain("return");
    if ( _pExpr )
	s += Chain(" ") + _pExpr->toChain();
    return s;
}
