#ifndef _CEGOPROCVAR_H_INCLUDED_
#define _CEGOPROCVAR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcVar.h
// -------------
// Cego procedure variable container class
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcVar
// 
// Description: data structure description for cego procedure parameters
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoFieldValue.h"

class CegoProcVar {

 public:

    enum VarType { INVAR, OUTVAR, BLOCKVAR };

    CegoProcVar();
    CegoProcVar(const Chain& varName);
    CegoProcVar(const Chain& varName, VarType paramType, CegoDataType dt, int dtlen, const CegoFieldValue& fv);
    ~CegoProcVar();
    
    void setName(const Chain& name);
    const Chain& getName() const;
    
    void setVarType(VarType type);
    VarType getVarType() const;

    CegoDataType getType() const;
    int getLength() const;

    void setValue(const CegoFieldValue& fv);
    const CegoFieldValue& getValue() const;

    CegoProcVar& operator = ( const CegoProcVar& pp);
    bool operator == ( const CegoProcVar& pp);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoProcVar& pp);
    
private:
    
    Chain _name;
    VarType _paramType;
    CegoDataType _dt;
    int _dtlen;
    CegoFieldValue _fv;
    
};

#endif




