///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcWhileStmt.cc  
// --------------------
// Cego procedure while look statement implementation
//               
// Design and Implementation by Bjoern Lemke
//                                   
// (C)opyright 2000-2010 Bjoern Lemke                  
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcWhileStmt
// 
// Description: see header file for description
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes 
#include <lfcbase/ListT.h>

// cego includes
#include "CegoProcWhileStmt.h"

CegoProcWhileStmt::CegoProcWhileStmt(CegoProcCond *pCond,
		      CegoProcBlock *pBlock,
		      CegoProcBlock *pParentBlock) : CegoProcStmt(pParentBlock)
{
    _pCond = pCond;
    _pBlock = pBlock;
    _pCond->setBlock(_pBlock);
}

CegoProcWhileStmt::~CegoProcWhileStmt()  
{
    if ( _pBlock )
	delete _pBlock;
    if ( _pCond )
	delete _pCond;
}

void CegoProcWhileStmt::setBlock(CegoProcBlock * pBlock)
{
    _pBlock = pBlock;
}

CegoException CegoProcWhileStmt::execute()
{

    while ( _pCond->eval() )
    {
	CegoException result;
	result =  _pBlock->execute();
	if ( result != NONE_EXCEP )
	    return result;
    }
    return NONE_EXCEP;
}

Chain CegoProcWhileStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = indent + Chain("while ") + _pCond->toChain() + Chain("\n") + indent + Chain("begin\n");
    s += _pBlock->toChain(indent + indent);
    s += indent + Chain("end");
    return s;
}
