#ifndef _CEGOPROCWHILESTMT_H_INCLUDED_
#define _CEGOPROCWHILESTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcWhileStmt.h  
// -------------------
// Cego procedure while loop statement block class definition
//              
// Design and Implementation by Bjoern Lemke
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcWhileStmt
// 
// Description: This class implements the while statement for cego stored procedures.
//              The condition and block information is stored stored for later execution  
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"
#include "CegoProcCond.h"

class CegoProcWhileStmt : public CegoProcStmt {
    
public:

    CegoProcWhileStmt(CegoProcCond  *pCond,
		      CegoProcBlock *pBlock,
		      CegoProcBlock *pParentBlock);

    ~CegoProcWhileStmt();

    void setBlock(CegoProcBlock* pBlock);
    
    CegoException execute();
  
    Chain toChain(const Chain& indent = Chain("")) const;

private:

    CegoProcCond *_pCond;
    CegoProcBlock* _pBlock;
};

#endif














