#ifndef _CEGOPROCEDURE_H_INCLUDED_
#define _CEGOPROCEDURE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcedure.h  
// ---------------
// Cego procedure class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoProcedure
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcVar.h"
#include "CegoExpr.h"

class CegoProcedure  {
    
 public:

    enum ProcType { PROCEDURE, FUNCTION };

    CegoProcedure();
    CegoProcedure(const Chain& procName, CegoProcBlock *pBlock);
    CegoProcedure(const Chain& procName, CegoProcBlock *pBlock, CegoDataType returnType, int returnTypeLen);

    ~CegoProcedure();

    void setMasterBlock(CegoProcBlock *pBlock);

    void getArgList(ListT<CegoProcVar>& argList);

    ListT<CegoProcVar>& getOutParamList();

    const Chain& getName() const;
    CegoProcBlock* getBlock();

    void execute(const ListT<CegoExpr*>& expList);
 
    CegoFieldValue getRetVal() const;

    ProcType getProcType() const;

    CegoProcedure& operator = (const CegoProcedure& p);
    bool operator == (const CegoProcedure& p) const;

    Chain toChain() const;

 private:
    
    CegoDataType _returnType;
    int _returnTypeLen;
    ProcType _procType;
    Chain _procName;
    CegoProcBlock* _pBlock;
    CegoProcBlock* _pMasterBlock;

    ListT<CegoProcVar> _outParamList;

};

#endif














