#ifndef _CEGOQUERY_H_INCLUDED_
#define _CEGOQUERY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQuery.h
// -----------
// Cego query handling
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoQuery
// 
// Description: CegoQuery implements a container class for insert, update and delete queries.
//              This is used for representation of such queries in the native parser but also 
//              inside stored procedures.    
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoDistManager.h"
#include "CegoPredDesc.h"
#include "CegoExpr.h"
#include "CegoAlterDesc.h"
#include "CegoReturnVar.h"
#include "CegoSelect.h"

class CegoQuery {
    
public:

    enum TransactionOp { START, COMMIT, ROLLBACK };

    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, TransactionOp to);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableName, const Chain& tableAlias, const Chain& tableSet, CegoPredDesc* pPred);
    CegoQuery(CegoDistManager* pGTM, const Chain& tableName, const Chain& tableAlias, const Chain& tableSet, CegoPredDesc* pPred, ListT<CegoField>& updSchema, const ListT<CegoExpr*>& updList, const ListT<CegoReturnVar*> retVarList);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableName, const Chain& tableSet, const ListT<CegoField>& schema, const ListT<ListT<CegoExpr*> >& exprListArray);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableName, const Chain& tableSet,  const ListT<CegoField>& schema, CegoSelect* pSelect);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableName, const Chain& tableSet, const ListT<CegoAlterDesc>& alterList);
    
    CegoQuery(CegoDistManager* pGTM,   const Chain& tableSet, const Chain& objName, CegoObject::ObjectType objType, const Chain& newObjName );    
   
    ~CegoQuery();

    void setBlock(CegoProcBlock *pBlock);

    Chain execute(CegoProcBlock* pBlock = 0);

    long getAffectedCount() const;
    
    Chain toChain(const Chain& indent) const;

private:

    enum QueryMode { INSERT_QUERY, 
		     INSERTBYSELECT_QUERY, 
		     DELETE_QUERY,
		     UPDATE_QUERY,
		     ALTER_QUERY,
		     RENAME_QUERY,
		     START_QUERY,
		     COMMIT_QUERY,
		     ROLLBACK_QUERY};

    void prepareFieldValue(CegoField *pFV, CegoFieldValue& fv, int pos);

    QueryMode _mode;
    CegoDistManager* _pGTM;
    Logger* _pLogger;
    Chain _tableName;
    Chain _tableAlias;
    Chain _objName;
    CegoObject::ObjectType _objType;

    Chain _newObjName;
    Chain _tableSet;

    ListT<CegoField> _schema;
    ListT<CegoExpr*> _updList;
    ListT<ListT<CegoExpr*> > _exprListArray;
    ListT<CegoReturnVar*> _retVarList;
    ListT<CegoAlterDesc> _alterList; 
    CegoPredDesc *_pPred;
    CegoSelect *_pSelect;
    bool _balancedIndex;
    long _affCount;
};

#endif




