///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryException.cc
// --------------------
// Cego procedure exception container class
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoQueryException
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoQueryException.h"

CegoQueryException::CegoQueryException(CegoException excep, const Chain& module, int line, const Chain& msg) : Exception(module, line, msg)
{
    _excep = excep;
}

CegoQueryException::CegoQueryException(CegoException excep, const Chain& module, int line, const Chain& msg, const Exception& e) : Exception(module, line, msg, e)
{
    _excep = excep;
}

CegoQueryException::~CegoQueryException()
{
}
    
CegoException CegoQueryException::getException() const
{
    return _excep;
}

CegoQueryException& CegoQueryException::operator = ( const CegoQueryException& qe)
{
    _excep = qe._excep;
    return (*this);
}

bool CegoQueryException::operator == ( const CegoQueryException& qe)
{
    if ( _excep == qe._excep )
	return true;
    return false;
}

Chain CegoQueryException::toChain() const
{
    Chain s("N/A");
    return s;
}
    
ostream& operator << (ostream& s, const CegoQueryException& qe)
{    
    s << qe.toChain();
    return s;
}
