#ifndef _CEGOQUERYHELPER_H_INCLUDED_
#define _CEGOQUERYHELPER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryHelper.h
// -----------------
// Cego query helper
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoQueryHelper
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>

// cego includes
#include "CegoAttrCond.h"
#include "CegoPredDesc.h"
#include "CegoCondDesc.h"
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoProcBlock.h"
#include "CegoExpr.h"
#include "CegoBlob.h"
#include "CegoTupleState.h"

class CegoQueryHelper {
    
public:

    enum AttrCondMatch { INAPP, PARTIAL, COMPLETE };

    CegoQueryHelper();
    ~CegoQueryHelper();

    void makeCNF(CegoCondDesc *pC);


    bool evalPredicate(ListT<CegoField>* pParentList,
		       int parentJoinBufPos,
		       int parentJoinBufSize,
		       ListT<CegoField>* joinBuf,
		       int pos,
		       int size, 
		       CegoPredDesc* pP, 
		       CegoProcBlock *pBlock = 0 );

    AttrCondMatch checkAttrCond(CegoAttrCond& ac,		      
		      CegoPredDesc* pP, 
		      const ListT<CegoField>& schema,
		      ListT<CegoField>* flArray, 
		      int flSize, 
		      CegoProcBlock *pBlock);

    Chain condToChain(CegoCondDesc* pC, int depth);
    Chain predToChain(CegoPredDesc* pP, int depth);
    
    void aggregateTuple(ListT<CegoField>& aggTuple, CegoExpr* pExpr);
    void aggregateTuple(ListT<CegoField>& aggTuple, CegoAggregation* pAgg);

    void prepareFieldValue(CegoField* pFV, CegoFieldValue& fv, int pos);

    void encodeFL(const ListT<CegoField>& fvl, char* &pBufBase, int &buflen);    
    void decodeFL(ListT<CegoField>& fvl, char* pc, int len);

    void encodeFVL(int tid, int tastep, CegoTupleState ts, const ListT<CegoField>& fvl, char* &pBufBase, int &buflen);
    void encodeFVL(int tid, int tastep, CegoTupleState ts, const ListT<CegoField>& fvl, const ListT<CegoBlob>& blobList, char* &pBufBase, int &buflen);

    void decodeFVL(ListT<CegoField>* fvlArray, int pos, char* pc, int len, int &tid, int &tastep, CegoTupleState& ts);
    void decodeFVL(ListT<CegoField>& fvl, char* pc, int len, int &tid, int& tastep, CegoTupleState& ts, bool doReset = true);
    void decodeFVL(ListT<CegoField>& fvl, ListT<CegoBlob>& blobList, char* pc, int len, int &tid, int& tastep, CegoTupleState& ts);

    void decodeNativeFVL(ListT<CegoFieldValue>& fvl, ListT<CegoBlob>& blobList, char* pc, int len, int &tid, int &tastep, CegoTupleState& ts);
    
    void decodeUpdRec(Chain& tableAlias,
		      CegoPredDesc* &pPred, 
		      ListT<CegoField>& updList, 
		      ListT<CegoExpr*>& exprList,
		      char* pBuf, int buflen,
		      CegoDistManager* pGTM); 
    
    void encodeUpdRec(const Chain& tableAlias,
		      CegoPredDesc* pPred, 
		      const ListT<CegoField>& updList,
		      const ListT<CegoExpr*>& exprList,
		      CegoProcBlock* pBlock,
		      char* &pBuf, int &buflen);

    void decodeDelRec(Chain& tableAlias,
		      CegoPredDesc* &pPred,
		      char* pBuf, int buflen,
		      CegoDistManager *pGTM);

    void encodeDelRec(const Chain& tableAlias,
		      CegoPredDesc* pPred,
		      CegoProcBlock* pBlock,
		      char* &pBuf, int &buflen);


    bool evalFields(CegoComparison comp, const CegoFieldValue& f1, const CegoFieldValue& f2);
    bool evalBetween(const CegoFieldValue& f1, const CegoFieldValue& f2, const CegoFieldValue& f3);

    
    void evalSelection(ListT<CegoExpr*>& exprList, ListT<CegoField>* joinBuf, int jbufSize, bool isAgg, ListT<CegoField>& ol);

private:

    
    void createConjunctionList(CegoPredDesc* pPred, ListT<CegoPredDesc*>& conjunctionList);
    

    AttrCondMatch evalAttrCond(CegoAttrCond& ac,		      
		      CegoPredDesc* pP, 
		      const ListT<CegoField>& schema,
		      ListT<CegoField>* flArray, 
		      int flSize, 
		      CegoProcBlock *pBlock);
    
    AttrCondMatch evalAttrCondbyCondition(CegoAttrCond& ac,
					  CegoCondDesc* pC,
					  const ListT<CegoField>& schema,
					  ListT<CegoField>* flArray, 
					  int flSize,
					  CegoProcBlock* pBlock);
    
};

#endif




