///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoReturnVar.cc  
// ----------------                                                     
// Cego return variable implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2010 Bjoern Lemke                        
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoReturnVar
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////


// cego includes
#include "CegoReturnVar.h"

CegoReturnVar::CegoReturnVar(const Chain& varName,
			     CegoExpr *pExpr)
{
    _varName = varName;
    _pExpr = pExpr;
}

CegoReturnVar::~CegoReturnVar()  
{
}

const Chain& CegoReturnVar::getVarName() const
{
    return _varName;
}

CegoExpr* CegoReturnVar::getExpr() const
{
    return _pExpr;
}

CegoReturnVar& CegoReturnVar::operator = ( const CegoReturnVar& rv)
{
    _varName = rv._varName;
    _pExpr = rv._pExpr;
    return (*this);
}

Chain CegoReturnVar::toChain() const
{
    Chain s;
    s = Chain(":")  + _varName + " = " + _pExpr->toChain();
    return s;
}
