#ifndef _CEGOSERIAL_H_INCLUDED_
#define _CEGOSERIAL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSerial.h
// ------------
// Cego serializer class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2012 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoSerial
// 
// Description: This class implements the serialization of any query request and response data
//              Since the xml protocol seems to throttle down query performance, this class
//              was introduced
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// lfc includes
#include <lfcbase/Chain.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoDecodableObject.h"

class CegoSerial {

 public:

    CegoSerial(NetHandler *pN);
    ~CegoSerial();
    
    void reset();
    bool isReset() const;

    void writeChain(const Chain& s);
    void writeSchema(const ListT<CegoField>& schema);
    void writeObject(const CegoDecodableObject& oe);
    void writeRow(const ListT<CegoField>& fl);
    void writeRow(const ListT<CegoFieldValue>& fvl);


    Chain readChain();
    ListT<CegoField> readSchema();
    ListT<CegoFieldValue> readRow(const ListT<CegoField>& schema);

    // void setSerial(const Chain& serial); 
    // const Chain& getSerial() const;

    int numAhead() const;

    // CegoSerial& operator = ( const CegoSerial& ser);
    Chain toChain() const;

    friend ostream& operator << (ostream& s, const CegoSerial& ser);

 private:

    NetHandler* _pN;
    // Chain _serial;
    Tokenizer* _pTok;
};

#endif
