#ifndef _CEGOSYSTEMOBJECT_H_INCLUDED_
#define _CEGOSYSTEMOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSystemObject.h
// ------------------
// Cego system object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoSystemObject
// 
// Description: Description of all system tables like $table, $procedure, etc,
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoObjectManager.h"
#include "CegoObjectCursor.h"

class CegoSystemObject : public CegoObjectManager {
    
public:
    
    CegoSystemObject(CegoDatabaseManager *pDBMng);
    ~CegoSystemObject();

    void createSystemSpace(int tabSetId);

    bool objectExists(int tabSetId, const Chain& objectName, CegoObject::ObjectType type);

    void getObject(int tabSetId, const Chain& objectName, CegoObject::ObjectType type, CegoDecodableObject& oe);
    void getObjectWithFix(int tabSetId, const Chain& objectName, CegoObject::ObjectType type, CegoDecodableObject& oe, CegoBufferPage &bp);
        
    void getObjectList(int tabSetId, CegoObject::ObjectType type, ListT<Chain>& objList);

private:
        
    unsigned long _modId;
};

#endif




