#ifndef _CEGOTABLECURSOR_H_INCLUDED_
#define _CEGOTABLECURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableCursor.h
// -----------------
// Cego TableCursor class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoTableCursor
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoObject.h"
#include "CegoDataPointer.h"
#include "CegoTableManager.h"
#include "CegoObjectCursor.h"
#include "CegoAVLIndexCursor.h"
#include "CegoBTreeCursor.h"
#include "CegoAttrCond.h"
#include "CegoField.h"
#include "CegoQueryHelper.h"
#include "CegoBTreeObject.h"

class CegoTableCursor {
    
public:
    
    CegoTableCursor();
    CegoTableCursor(CegoTableManager* pTM, int tabSetId, const Chain& tableName, bool ignoreTouched = false);
    ~CegoTableCursor();
    
    CegoAttrCond::IndexMatch setup(const CegoAttrCond& attrCond);

    bool getFirst(ListT<CegoField>& fl, CegoDataPointer& dp);
    bool getNext(ListT<CegoField>& fl, CegoDataPointer& dp);

    const Chain& getIndexName() const;

    void getIdxSchema(ListT<CegoField>& idxSchema);

    void abort();

protected:

    CegoTableManager* _pTM;
    Chain _tableName;

 private:

    CegoAVLIndexCursor* _pIC;
    CegoBTreeCursor* _pBTC;

    CegoObjectCursor* _pC;
    CegoAttrCond _attrCond;

    CegoTableObject *_pOE;
    CegoBTreeObject *_pBTO;

    ListT<CegoTableObject> _idxList;
    ListT<CegoBTreeObject> _btreeList;
    ListT<CegoKeyObject> _keyList;
    ListT<CegoCheckObject> _checkList;
    ListT<CegoField> _idxSchema;

    Chain _idxAttrName;
    bool _idxSetup;
    bool _idxFound;
    Chain _idxName;
    CegoObject::ObjectType _type;
    CegoAttrCond::IndexMatch _idxMatch;
    int _tabSetId;
    bool _ignoreTouched;
    bool _readUncommitted;

    CegoQueryHelper _qh;

    Logger* _pLogger;
    unsigned long _modId;
};

#endif
