///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableDesc.cc
// ----------------
// Cego database table description implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoTableDesc
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoTableDesc.h"
#include "CegoXMLdef.h"

#include <string.h>
#include <stdlib.h>

CegoTableDesc::CegoTableDesc()
{
}

CegoTableDesc::CegoTableDesc(char* buf)
{
    decode(buf);
}

CegoTableDesc::CegoTableDesc(Element* pTDE)
{
    fromElement(pTDE);
}

CegoTableDesc::CegoTableDesc(const CegoTableDesc& td)
{
    
    _tableName = td._tableName;
    _tableAlias = td._tableAlias;    
}

CegoTableDesc::CegoTableDesc(const Chain& tableName, const Chain& tableSet)
{
    _tableName = tableName;
    _tableSet = tableSet;
}

CegoTableDesc::CegoTableDesc(const Chain& tableName, const Chain& tableSet, const Chain& tableAlias)
{
    _tableName = tableName;
    _tableSet = tableSet;
    _tableAlias = tableAlias;
}

CegoTableDesc::~CegoTableDesc()
{
}
    
void CegoTableDesc::setTableName(const Chain& tableName)
{
    _tableName = tableName;
}
 
const Chain& CegoTableDesc::getTableName() const
{
    return _tableName;
}

void CegoTableDesc::setTableSet(const Chain& tableSet)
{
    _tableSet = tableSet;
}
 
const Chain& CegoTableDesc::getTableSet() const
{
    return _tableSet;
}

void CegoTableDesc::setTableAlias(const Chain& tableAlias)
{
    _tableAlias = tableAlias;
}

const Chain& CegoTableDesc::getTableAlias() const
{
    return _tableAlias;
}
        
CegoTableDesc& CegoTableDesc::operator = ( const CegoTableDesc& td)
{
    _tableName = td._tableName;
    _tableSet = td._tableSet;
    _tableAlias = td._tableAlias;

    return (*this);
}
    
bool CegoTableDesc::operator == ( const CegoTableDesc& td)
{
    if ( _tableName == td._tableName 
	 && _tableSet == td._tableSet
	 && _tableAlias == td._tableAlias)
	return true;
    return false;
}

void CegoTableDesc::encode(char *buf)
{
    
    char* pBuf = (char*)buf;

    char len = _tableName.length();

    memcpy( pBuf, &len, sizeof(char));
    pBuf = pBuf + sizeof(char);

    if ( len > 0 )
    {
	memcpy( pBuf, (char*)_tableName, len);
	pBuf = pBuf + len;
    }
     
    len = _tableSet.length();

    memcpy( pBuf, &len, sizeof(char));
    pBuf = pBuf + sizeof(char);

    if ( len > 0 )
    {
	memcpy( pBuf, (char*)_tableSet, len);
	pBuf = pBuf + len;
    }
    
    len = _tableAlias.length();

    memcpy( pBuf, &len, sizeof(char));
    pBuf = pBuf + sizeof(char);

    if ( len > 0 )
    {
	memcpy( pBuf, (char*)_tableAlias, len);
	pBuf = pBuf + len;
    }
}

void CegoTableDesc::decode(char *buf)
{

    char* pBuf = (char*)buf;

    char len;
    
    memcpy( &len, pBuf, sizeof(char));
    pBuf = pBuf + sizeof(char);
    
    if ( len == 0 )
    {
	_tableName = Chain();
    }
    else
    {
	_tableName = Chain(pBuf, len-1);
	pBuf = pBuf + len;
    }

    memcpy( &len, pBuf, sizeof(char));
    pBuf = pBuf + sizeof(char);
    
    if ( len == 0 )
    {
	_tableSet = Chain();
    }
    else
    {
	_tableSet = Chain(pBuf, len-1);
	pBuf = pBuf + len;
    }


    memcpy( &len, pBuf, sizeof(char));
    pBuf = pBuf + sizeof(char);
    
    if ( len == 0 )
    {
	_tableAlias = Chain();
    }
    else
    {
	_tableAlias = Chain(pBuf, len-1);
	pBuf = pBuf + len;
    }
}

int CegoTableDesc::getEncodingLength() const
{

    return 3 * sizeof(char) + _tableName.length() + _tableSet.length() + _tableAlias.length();

}

Element* CegoTableDesc::toElement() const
{
    Element *pTableDescElement = new Element( XML_TABLEDESC_ELEMENT );
    pTableDescElement->setAttribute( XML_TABLENAME_ATTR, _tableName );
    pTableDescElement->setAttribute( XML_TABLESET_ATTR, _tableSet );
    pTableDescElement->setAttribute( XML_TABLEALIAS_ATTR, _tableAlias );
    
    return pTableDescElement;
}

void CegoTableDesc::fromElement(Element *pTableDescElement)
{
    _tableName = pTableDescElement->getAttributeValue(XML_TABLENAME_ATTR);
    _tableSet = pTableDescElement->getAttributeValue(XML_TABLESET_ATTR);
    _tableAlias = pTableDescElement->getAttributeValue(XML_TABLEALIAS_ATTR);
}

Chain CegoTableDesc::toChain() const
{
    Chain s;
    s = _tableName + "@" + _tableSet + " " + _tableAlias;
    return s;
}

ostream& operator << (ostream& s, const CegoTableDesc& td)
{    
    s <<  td._tableName << "(" << td._tableAlias << ")";
    return s;
}

