#ifndef _CEGOTABLEDESC_H_INCLUDED_
#define _CEGOTABLEDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableDesc.h
// ---------------
// Cego table description
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoTableDesc
// 
// Description: Data structure for cego table description
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// xml includes
#include <lfcxml/Element.h>

class CegoTableDesc {

 public:

    CegoTableDesc();
    CegoTableDesc(char* buf);
    CegoTableDesc(Element* pTDE);
    CegoTableDesc(const CegoTableDesc& td);
    CegoTableDesc(const Chain& tableName, const Chain& tableSet);
    CegoTableDesc(const Chain& tableName, const Chain& tableSet, const Chain& tableAlias);
    ~CegoTableDesc();
    
    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    void setTableSet(const Chain& tableSet);
    const Chain& getTableSet() const;
    
    void setTableAlias(const Chain& tableName);
    const Chain& getTableAlias() const;
    
    CegoTableDesc& operator = ( const CegoTableDesc& ad);
    bool operator == ( const CegoTableDesc& ad);

    void encode(char *buf);
    void decode(char *buf);
    int getEncodingLength() const;

    Element* toElement() const;
    void fromElement(Element *pTableDescElement);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoTableDesc& td);
    
private:
    
    Chain _tableName;
    Chain _tableSet;
    Chain _tableAlias;
    
};

#endif




