#ifndef _CEGOTERM_H_INCLUDED_
#define _CEGOTERM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTerm.h
// ----------
// Cego term class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoTerm
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcStmt.h"
#include "CegoFieldValue.h"
#include "CegoFactor.h"

class CegoDistManager;

class CegoTerm {

 public:

    enum TermType { MUL, DIV, FACTOR  };

    CegoTerm();
    CegoTerm(char* buf, CegoDistManager *pGTM);
    CegoTerm(Element* pTermElement, CegoDistManager *pGTM);
    CegoTerm(CegoTerm *pTerm, CegoFactor *pFac, TermType termType);
    CegoTerm(CegoFactor *pFactor);
    ~CegoTerm();

    // void setFieldList(ListT<CegoField> *pFL);
    void setFieldListArray(ListT<CegoField> *fla, int size);
    void setBlock(CegoProcBlock *pBlock);

    void clearAttrCache();

    void getSelectQueryList(ListT<CegoSelect*>& queryList);

    bool getTableDesc(CegoTableDesc& td) const;

    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    ListT<CegoField> getFieldList() const;
    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    CegoField evalField() const;
    CegoFieldValue evalFieldValue() const;

    TermType getType() const;
    CegoFactor* getFactor();
    CegoTerm* getTerm();

    ListT<CegoAggregation*> getAggregationList();

    CegoTerm* clone(bool isAttrRef = false);

    CegoTerm& operator = ( const CegoTerm& e);

    Chain toChain() const;
    Element* toElement() const;
    void fromElement(Element *pTermElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoTerm& e);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM);
    int getEncodingLength() const;

    void getPlanList(ListT<Element*>& planList);

 private:

    TermType _termType;

    CegoTerm *_pTerm;
    CegoFactor *_pFactor;

};

#endif
