#ifndef _CEGOTRANSACTIONMANAGER_H_INCLUDED_
#define _CEGOTRANSACTIONMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTransactionManager.h
// ------------------------
// Cego transaction manager class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoTransactionManager
// 
// Description: Transaction handling
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDefs.h"
#include "CegoTableManager.h"
#include "CegoTableObject.h"
#include "CegoQueryHelper.h"

#define MAXTRANSACTION 30

// forward declaration
class CegoTableManager;

class CegoTransactionManager {
    
 public:

    CegoTransactionManager(CegoTableManager* pTM);
    ~CegoTransactionManager();
       
    void release(int tabSetId);

    void initLock(int tabSetId);
    void reorgSystemSpace(int tabSetId);

    void recordUpdate(int tabSetId, int tid, const CegoDataPointer& dp );
    void commitUpdate(int tabSetId, const Chain& idxName, int tid, bool doAppend);

    void getRBDataPtr(int tabSetId, int tid, int fileId, int pageId, int offset, int& rbfileId, int& rbpageId, int& rboffset);

    void newRBEntry(int tabSetId, int tid, int fileId, int pageId, int offset, const Chain& tableName);
    
    long commitTransaction(int tabSetId, int tid);

    void getTransactionAffectedTables(int tabSetId, int tid, SetT<Chain>& tableList);

    void finishOpenTransaction(int tabSetId);
    long rollbackTransaction(int tabSetId, int tid);
    
    void getTransactionInfo(int tabSetId, const Chain& rbo, int& numop);
     
 private:

    long doCommit(int tabSetId, const Chain& rbo);
    long doRollback(int tabSetId, const Chain& rbo);

    class TAEntry {
	
    public:
	
	TAEntry();
	TAEntry(const int tid);
	TAEntry(const int tid, const CegoBufferPage& bp, const CegoTableObject& oe);
	~TAEntry();

	const int getTid() const;

	CegoBufferPage& getBufferPage();
	CegoTableObject& getTableObject();
	CegoDataPointer getDataPointer();

	TAEntry& operator = ( const TAEntry& t);
        bool operator == ( const TAEntry& t);
	
	friend ostream& operator << (ostream& s, const TAEntry& t)
	{
	    s << "(" << t._tid << ")";
	    return s;
	}

    private:

	int _tid;
	CegoBufferPage _bp;
	CegoTableObject _oe;
    };


    ListT<TAEntry> _taList;
    ListT<TAEntry> _udList;

    CegoDatabaseManager *_pDBMng;
    CegoTableManager* _pTM;

    ListT<CegoField> _updSchema;
    ListT<CegoField> _rbcatSchema;

    /*
    CegoBufferPage _pRBPage[MAXTRANSACTION];
    CegoTableObject _rbe[MAXTRANSACTION];
    CegoDataPointer _rbEntry[MAXTRANSACTION];
    */

    CegoQueryHelper _qh;

    unsigned long _modId;
};

#endif




