#ifndef _CEGOTYPECONVERTER_H_INCLUDED_
#define _CEGOTYPECONVERTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTypeConverter.h
// -------------------
// Cego type converter
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoTypeConverter
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDataType.h"
#include "CegoObject.h"

extern const char *CEGO_TYPE_MAP[];
extern const int CEGO_JAVATYPE_MAP[];

class CegoTypeConverter {
    
public:

    CegoTypeConverter();
    ~CegoTypeConverter();

    Chain getTypeString(CegoDataType type) const;
    CegoDataType getTypeId(const Chain& typeString);
    int getTypeLen(CegoDataType type, const Chain& val = Chain("")) const;

    Chain getObjectTypeString(CegoObject::ObjectType type) const;
    CegoObject::ObjectType getObjectTypeId(const Chain& typeString);

};


#endif
