///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoView.cc
// -----------
// Cego view cache object
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: CegoView
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoView.h"
#include "CegoSelect.h"

CegoView::CegoView()
{
}

CegoView::CegoView(const Chain& viewName, CegoSelect *pSelect)
{
    _viewName = viewName;
    _pSelect = pSelect;
}
 
CegoView::~CegoView()
{
    delete _pSelect;
}

const Chain& CegoView::getViewName() const
{
    return _viewName;
}

CegoSelect* CegoView::getSelect() const
{
    return _pSelect;
}

CegoView& CegoView::operator = ( const CegoView& v )
{
    _viewName = v._viewName;
    _pSelect = v._pSelect;
    return (*this);
}

bool CegoView::operator == ( const CegoView& v)
{    
    if (_viewName == v._viewName)
	return true;
    return false;
}

Chain CegoView::toChain() const
{
    return _viewName;
}

ostream& operator << (ostream& s, const CegoView& v)
{
    s <<  v._viewName;
    return s;
}
