#ifndef _CEGOVIEW_H_INCLUDED_
#define _CEGOVIEW_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoView.h
// ----------
// Cego view cache object
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoView
// 
// Description:
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

class CegoSelect;

class CegoView {

 public:
    
    CegoView();
    CegoView(const Chain& viewName, CegoSelect *pSelect);
    ~CegoView();

    const Chain& getViewName() const;
    CegoSelect* getSelect() const;

    CegoView& operator = ( const CegoView& v);
    bool operator == ( const CegoView& v);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoView& v);
    
private:
    
    Chain _viewName;
    CegoSelect *_pSelect;

};

#endif




