#ifndef _CEGOVIEWOBJECT_H_INCLUDED_
#define _CEGOVIEWOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoViewObject.h
// ----------------
// Cego view object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoViewObject
// 
// Description: Cego view object structure
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoContentObject.h"

class CegoViewObject : public CegoContentObject {

 public:

    CegoViewObject();
    CegoViewObject(Element *pVO);
    CegoViewObject(const CegoViewObject& vo);
    CegoViewObject(const Chain& viewName, int tabSetId = 0);

    CegoViewObject(int tabSetId, const Chain& viewName, const ListT<CegoField>& schema, const Chain& viewStmt);
	
    ~CegoViewObject();
    
    int getEntrySize() const;
    void encode(char *buf);
    void decode(char *buf);

    void setSchema(const ListT<CegoField>& schema);   
    
    const Chain& getViewStmt() const;
    void setViewStmt(const Chain& viewStmt);

    void setEmpty();
    
    CegoViewObject& operator = ( const CegoViewObject& vo);
    bool operator == ( const CegoViewObject& vo);
    
    Chain toChain() const;
    CegoContentObject* clone(bool isAttrRef=false);

    Element* getElement() const;
    void putElement(Element* pElement);
    Chain getFormatted() const;

 private:

    Chain fill(const Chain& s, int num) const;
    Chain _viewStmt;

};

#endif
