#ifndef _CEGOXPorter_H_INCLUDED_
#define _CEGOXPORTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoXPorter.h
// -------------
// Cego import and export class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2010 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: CegoXPorter
// 
// Description: 
//
// Status: QG-2.6
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDefs.h"
#include "CegoBufferPool.h"
#include "CegoDistManager.h"
#include "CegoDbThreadPool.h"

class CegoXPorter {
    
 public:

    CegoXPorter(CegoDistManager *pGTM, CegoDbThreadPool *pDbPool = 0);
    ~CegoXPorter();


    void xmlExportTableSet(const Chain& tableSet, bool isStructure, const Chain& expFile);
    void xmlImportTableSet(const Chain& tableSet, bool isStructure, const Chain& impFile, bool doLogging);

    void xmlExportTable(const Chain& tableSet, const Chain& tableName, const Chain& expFile);
    void xmlImportTable(const Chain& tableSet, const Chain& tableName, const Chain& impFile, bool doLogging);

    void binExportTableSet(const Chain& tableSet, bool isStructure, const Chain& expFile, bool doPlain);
    void binImportTableSet(const Chain& tableSet, bool isStructure, const Chain& impFile, bool doLogging, bool doPlain);

    void binExportTable(const Chain& tableSet, const Chain& tableName, const Chain& expFile, bool doPlain);
    void binImportTable(const Chain& tableSet, const Chain& tableName, const Chain& impFile, bool doLogging, bool doPlain);
    
 private:
    
    enum BinTag { TSTAG, TABTAG, IDXTAG, VIEWTAG, PROCTAG, KEYTAG, FLDTAG, ROWTAG, EOFTAG, SEPTAG, CNTTAG, CHECKTAG };

    void writeHeader(File *pOutFile, const Chain& tableSet);

    void writeTableObject(File *pOutFile, int tabSetId, const Chain& tableName, const ListT<CegoField>& schema, bool doPlain);
    void writeIndexObject(File *pOutFile, int tabSetId, const Chain& idxName, const Chain& tableName, CegoObject::ObjectType type, const ListT<CegoField>& schema);
    void writeKeyObject(File *pOutFile, int tabSetId, const Chain& keyName, const Chain& tableName, const Chain& refTable, 
			const ListT<CegoField>& keySchema, const ListT<CegoField>& refSchema);

    void writeCheckObject(File *pOutFile, int tabSetId, const Chain& checkName, const Chain& tableName, 
			  CegoPredDesc *pPredDesc);

    void writeViewObject(File *pOutFile, int tabSetId, const Chain& viewName, const ListT<CegoField>& keySchema, const Chain& viewStmt);
    void writeProcObject(File *pOutFile, int tabSetId, const Chain& procName, const Chain& procText);
    void writeCounterObject(File *pOutFile, int tabSetId, const Chain& counterName, long counterValue);

    void writeTableData(File *pOutFile, int tabSetId, const Chain& tableName, const ListT<CegoField>& schema, bool doPlain);
    void writeRow(File *pOutFile, int tabSetId, const ListT<CegoField>& rowSchema);

    void readHeader(File *pInFile, Chain& tableSet);
    void readTableObject(File *pInFile, const Chain& tableSet, bool doLogging, bool doPlain);
    void readIndexObject(File *pInFile, const Chain& tableSet);
    void readKeyObject(File *pInFile, const Chain& tableSet);
    void readCheckObject(File *pInFile, const Chain& tableSet);
    void readViewObject(File *pInFile, const Chain& tableSet);
    void readProcObject(File *pInFile, const Chain& tableSet);
    void readCounterObject(File *pInFile, const Chain& tableSet);
    void readRow(File *pInFile, int tabSetId, const Chain& tableName, const ListT<CegoField>& rowSchema, bool doLogging);

    BinTag _tag;

    CegoDistManager *_pGTM;
    CegoDatabaseManager *_pDBMng;
    CegoDbThreadPool *_pDbPool;

    CegoTableObject _oe;

    ListT<CegoTableObject> _idxList;
    ListT<CegoBTreeObject> _btreeList;
    ListT<CegoKeyObject> _keyList;
    ListT<CegoCheckObject> _checkList;
    
    CegoBufferPage* _pPage;
    CegoDataPointer _sysEntry;

    bool _isFirst;

    char _inBuf[XP_MAXINBUF];
    char _colBuffer[XP_MAXCOLBUF];
    char _pdBuffer[XP_MAXPDBUF];

    unsigned long _modId;
};

#endif




