--
-- cego advanced date functions
--

drop if exists procedure second;
drop if exists procedure minute;
drop if exists procedure hour;
drop if exists procedure day;
drop if exists procedure month;
drop if exists procedure year;

@
create procedure second(ts in datetime) return int
begin
	var i int;
	:i = str2int(date2str(:ts, '%S'));
	return :i;
end;
@

@
create procedure minute(ts in datetime) return int
begin
	var i int;
	:i = str2int(date2str(:ts, '%M'));
	return :i;
end;
@

@
create procedure hour(ts in datetime) return int
begin
	var i int;
	:i = str2int(date2str(:ts, '%H'));
	return :i;
end;
@

@
create procedure day(ts in datetime) return int
begin
	var i int;
	:i = str2int(date2str(:ts, '%d'));
	return :i;
end;
@

@
create procedure month(ts in datetime) return int
begin
	var i int;
	:i = str2int(date2str(:ts, '%m'));
	return :i;
end;
@

@
create procedure year(ts in datetime) return int
begin
	var i int;
	:i = str2int(date2str(:ts, '%Y'));
	return :i;
end;
@

:x = call month(date('%d.%m.%Y %H:%M:%S', '21.07.2011 14:14:00'));
print :x;
:x = call year(date('%d.%m.%Y %H:%M:%S', '21.07.2011 14:14:00'));
print :x;
:x = call second(date('%d.%m.%Y %H:%M:%S', '21.07.2011 14:14:12'));
print :x;
:x = call second(sysdate);
print :x;
