--
-- ### Foreign key checks
--

-- one-dimensional fkey
create table t1 ( primary a int not null, b int );
create table t2 ( primary c int not null, a int );
alter table t2 add foreign key fk1 ( a ) references t1 ( a );

tableinfo t2;

insert into t1 values ( 1, 22);
insert into t1 values ( 2, 33);
insert into t1 values ( 3, 44);
insert into t1 values ( 4, 55);

insert into t2 values ( 1, 1);
insert into t2 values ( 2, 2);
insert into t2 values ( 3, 3);


update t1 set b = 23 where a = 1;


select * from t2;


drop table t1;
drop table t2;

-- multidimensional fkey
create table t1 ( primary a int not null, primary  b int not null );
create table t2 ( primary c int not null, a int, b int );
alter table t2 add foreign key fk1 ( a, b ) references t1 ( a, b );

insert into t1 values ( 1, 1 );
insert into t1 values ( 1, 2 );
insert into t1 values ( 1, 3 );
insert into t1 values ( 1, 4 );
insert into t1 values ( 2, 1 );
insert into t1 values ( 2, 2 );
insert into t1 values ( 2, 3 );
insert into t1 values ( 2, 4 );

insert into t2 values ( 100, 1, 1 );
tableinfo t2;

-- fkey is dropped with table drop
drop table t1;

tableinfo t2;
insert into t2 values ( 101, 1, 100 );
drop table t2;
