--
-- ### Check advanced aggregation
--

drop if exists procedure mny2str;
@
create procedure mny2str(m in fixed(2)) return string(50)
begin
   return :m | ' Euro';
end;
@

drop if exists table t1;
drop if exists table t2;
drop if exists table t3;
create table t1 ( a datetime );
create table t2 ( a int, b int, c int );
create table t3 ( a fixed(2) );

insert into t1 values ( sysdate );
select sum( date2int(a) )  from t1;

insert into t2 values ( 1, 2, 3 );
insert into t2 values ( 100, 20, 77 );


insert into t3 values ( (fixed)1.23 );
insert into t3 values ( (fixed)2.37 );

select sum(a) + sum(b) + sum(c), sum(a) - sum(b), avg(a), avg(b) from t2;
select count(a) + sum(b), avg(a) - sum(b) - sum(a) from t2;

select mny2str(sum(a)) from t3;

