#ifndef _CEGOACTION_H_INCLUDED_
#define _CEGOACTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAction.h  
// ------------
// Cego semantic actions interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAction
// 
// Description: The CegoAction class is the derived parser class for all semantic database 
//              actions. This requires a dragon generated parser class.
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/StackT.h>
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "Cego.h"
#include "CegoComparison.h"
#include "CegoDataType.h"
#include "CegoTableManager.h"
#include "CegoTransactionManager.h"
#include "CegoField.h"
#include "CegoQuery.h"
#include "CegoSelect.h"
#include "CegoCondDesc.h"
#include "CegoAttrDesc.h"
#include "CegoPredDesc.h"
#include "CegoDbHandler.h"
#include "CegoProcVar.h"
#include "CegoProcBlock.h"
#include "CegoProcedure.h"
#include "CegoExpr.h"
#include "CegoTerm.h"
#include "CegoFactor.h"
#include "CegoProcCond.h"
#include "CegoProcPred.h"
#include "CegoAlterDesc.h"
#include "CegoProcException.h"
#include "CegoCaseCond.h"

class CegoDbThreadPool;

class CegoAction : public Cego {
    
public:
    

    CegoAction(CegoDistManager *pTabMng, CegoDbThreadPool *pDbPool = 0 );
    ~CegoAction();

    void setTableSet(const Chain& tableSet);
    const Chain& getTableSet();

    void setDbHandle(CegoDbHandler *pDbHandle);
    CegoSelect* getSelect();
    CegoProcedure* getProcedure();

    void cleanUp();
    void setCommandChain(char* pC);
    char nextChar();
    void readChain();
    void backChar();

    void printTokenList();

    /////////////////////////////////////////////////
    /////////// start of semantic actions ///////////
    /////////////////////////////////////////////////

    void execSync();
    void execShowDataBase();
    void execListTableSet();
    void execListTable();
    void execListView();
    void execListProc();
    void execListIndex();
    void execListBTree();
    void execListKey();
    void execListCounter();
    void execListSysObj();
    void execListTmpObj();
    void execListCheck();

    void setTableSetOpt();

    void execTableInfo();
    void execShowUptime();
    void execShowPool();
    void execShowSystemSpace();
    void execTableDesc();
    void execIndexDesc();
    void execBTreeDesc();
    void execViewDesc();
    void execKeyDesc();
    void execCheckDesc();
    void execProcDesc();

    void execProcShow();
    void execViewShow();
    void execCheckShow();

    void execSetTableSet();
    void execAuthUser();

    void execEnableAppendMode();
    void execDisableAppendMode();

    void execEnableBTreeCache();
    void execDisableBTreeCache();
    
    void execEnableAutoCommit();
    void execDisableAutoCommit();

    void execSetIsolation();

    void execEnableUpdateSync();
    void execDisableUpdateSync();

    void execTableReorganize();
    void execIndexReorganize();
    void execSelect();
    void execSelectPlan();
    void execQuery();

    void execViewCreate();
    void execViewLoad();
    void execViewDrop();

    void execProcCreate();
    void execProcLoad();
    void execProcCall();
    void execFuncCall();

    void execUserTableCreate();
    void execPrimaryIndexCreate();
    void execIndexCreate();
    void execTableDrop();
    void execIndexDrop();
    void execProcDrop();
    void execFKeyDrop();
    void execCheckDrop();
    void execBTreeDrop();

    void dropOpt1();
    void dropOpt2();

    void execForeignKeyCreate();
    void execCheckCreate();
    void execAssignStatement();
    void execPrint();
    void execIndexCheck();
    void execCreateCounter();
    void execDropCounter();
    void execSetCounter();
    void execCounterId();

    // JDBC info calls 
    void jdbcInfo();
    void jdbcArg1();
    void jdbcArg2();

    // procedure actions

    void procHead();
    void procStore();
    void procReturnOpt();
    void procArg1();
    void procArg2();
    void procStoreBlock();
    void procVarStatement();
    void procCursorCreateStatement();
    void procCursorCloseStatement();
    void procAssignStatement();
    void procAssign2NullStatement();
    void procInitialAssignment1();
    void procInitialAssignment2();

    void procThrowStatement();
    void procNoopStatement();
    void procIfStatement();
    void procStoreIfBlock();
    void procStoreElseBlock();
    void procElsePart();
    void procIfCondition();
    void procElsIfCondition();
    void procWhileStatement();
    void procWhileCondition();
    void procCondition1();
    void procCondition2();
    void procCondition3();
    void procPredicate1();
    void procPredicate2();
    void procPredicate3();
    void procPredicate4();

    void procExceptionStatement();
    void procExceptionCondition();

    void procExpr1();
    void procExpr2();
    void procExpr3();
    void procExpr4();
    void procTerm1();
    void procTerm2();
    void procTerm3();
    void procFactor1();
    void procFactor2();
    void procFactor3();
    void procFactor4();
    void procFactor5();
    void procFactor6();
    void procFactor7();
    void procFactor8();

    void procFactor9();
    void procFactor10();
    void procFactor11();
    void procFactor12();
    void procFactor13();
    void procFactor14();

    void caseClause();
    void caseConditionList1();
    void caseConditionList2();
    void caseCondition();
    void casePrepare();

    void procStoreFetchArg1();
    void procStoreFetchArg2();
    void procQueryStatement();
    void procValueSpec(); 
    void procExprValue();
    void procReturnStatement1();
    void procReturnStatement2();
    void procBlockStart();
    void procBlockStatement();

    void setUniqueIndex();
    void setAVLIndex();
    void setBTreeIndex();

    void setPrimaryColumn();
    void setOrdinaryColumn();
    void setColumnDesc();
    void setNullOpt();
    void setNotNullOpt();

    void defaultOpt();
    void defaultNullOpt();

    void createSimpleAttrList();
    void createSimpleAttr();

    void startStore();
    void commitStore();
    void rollbackStore();

    // query actions

    void insertStore();
    void insertPrepare();
    void insertBySelectStore();
    void insertArg();
    void insertValueSpecStoreExecute();     
    void insertExprValue();    

    void unionAllStore();
    void selectStore();
    void selectSelectionStore1();
    void selectSelectionStore2();
    void selectionList1();
    void selectionList2();
    void selectItem();

    void selectTableListStore();
    void selectJoinSpecStore();
    void selectTable1();
    void selectTable2();
    void selectStackJoinTable();

    void selectInnerJoinStore();
    void selectLeftOuterJoinStore();
    void selectRightOuterJoinStore();

    void aliasOpt();
    void noAliasOpt();

    void selectGroupClause();
    void selectEmptyGroupClause();

    void selectGroupList1();
    void selectGroupList2();
    void selectHavingClause();
    void selectEmptyHavingClause();

    void selectOrderingClause();
    void selectEmptyOrderingClause();
    void selectOrderingList1();
    void selectOrderingList2();
    void selectOrderingAsc();
    void selectOrderingDesc();

    void selectDistinctOpt();
    void selectLimitOpt1();
    void selectLimitOpt2();

    void updateStore();
    void updateAssignment();
    void returnVarAssignment();
    
    void deleteStore();

    void alterStore();
    void alterAddCol();
    void alterDropCol();
    void alterModCol();
    void alterModDefault();
    void alterRenameCol();
   
    void renameTable();
    void renameIndex();
    void renameBTree();
    void renameKey();
    void renameProcedure();
    void renameView();
    void renameCheck();

    void functionNative();
    void functionNextCount();
    void functionSetCount();

    void functionUserDef1();
    void functionUserDef2();

    void functionExprList1();
    void functionExprList2();
    
    void wcWhereClause();
    void wcEmptyClause();
   
    void wcConditionAnd();
    void wcConditionOr();
    void wcConditionPredicate();

    void wcPredicateQueryExists();

    void wcPredicateQueryIn();
    void wcPredicateQueryNotIn();

    void wcPredicateQueryComp();

    void wcPredicateExprComp();
    void wcPredicateBetween();

    void wcPredicateNullComp();
    void wcPredicateNotNullComp();
    void wcPredicateLikeComp();
    void wcPredicateNotLikeComp();

    void wcPredicateCondition();
    void wcPredicateNotPredicate();

    void miscIntType();
    void miscLongType();
    void miscStringType();
    void miscBoolType();
    void miscDateTimeType();
    void miscBigIntType();
    void miscFloatType();
    void miscDoubleType();
    void miscSmallIntType();
    void miscTinyIntType();
    void miscDecimalType();
    void miscFixedType();
    void miscBlobType();
    void miscClobType();

    void miscEqualComp();
    void miscNotEqualComp();
    void miscLessComp();
    void miscMoreComp();
    void miscLessEqualComp();
    void miscMoreEqualComp();
    void miscAttribute1();
    void miscAttribute2();
    void miscAttribute3();


    void miscIntString();
    void miscNegatedIntString();

    void miscFloatString();
    void miscNegatedFloatString();

    
    void miscStringValue();
    void miscIntValue();
    void miscLongValue();
    void miscBigIntValue();
    void miscSmallIntValue();
    void miscTinyIntValue();

    void miscFloatValue();
    void miscDoubleValue();
    void miscDecimalValue();
    void miscFixedValue();

    void miscNull();
    void miscSysDate();
    void miscFormatDate();

    void miscDateFormat();
    void miscDateValue();

    void miscTrueValue();
    void miscFalseValue();
    void miscBlobRef();
    void miscClobRef();

    void setObject1();
    void setObject2();
    void setObject3();

    void setUpdDelAlias();

private:

    void reallocateStringBuf();
    Chain getPlanString(Element *pPlan, const Chain& title, int indent = 0);
    Chain getJoinPlanString(Element *pJoin, const Chain& title, int indent = 0);

    void formatTableInfo(const Chain& tableSet, const Chain& tableName, 
			 const ListT<CegoTableObject>& idxList,
			 const ListT<CegoBTreeObject>& btreeList,
			 const ListT<CegoKeyObject>& keyList,
			 const ListT<CegoCheckObject>& checkList,
			 CegoTableObject& oe,
			 ListT< ListT<CegoFieldValue> > &fa);


    int _i;
    char *_pC;

    int _stringBufLen;
    char *_stringBuf; // [MAXSTRINGLEN];

    int _aliasCount;

    Chain _fieldName;
    CegoDataType _dataType;
    int _dataLen;

    CegoDistManager* _pTabMng;
    
    CegoFieldValue _fieldValue;
    CegoFieldValue _defaultValue;

    // list variables

    ListT<CegoField> _fal;
    ListT<CegoContentObject*> _coList;
    ListT<CegoProcCond*> *_pCondList;
    ListT<CegoProcBlock*> *_pIfBlockList;
    ListT<CegoField> _fieldList;
    ListT<CegoAlterDesc> _alterList;
    ListT<CegoField> _idxList;
    ListT<Chain> _jdbcArgList;
    ListT<CegoAttrDesc*>* _pGroupList;
    ListT<CegoExpr*>* _pOrderingList;
    ListT<CegoOrderNode::Ordering>* _pOrderingOptList;

    ListT<CegoProcVar> _procArgList;
    ListT<Chain> _fetchList;
    ListT<CegoExpr*> _exprList;
    ListT<ListT<CegoExpr*> > _exprListArray;
    ListT<CegoReturnVar*> _returnVarList;
    
    // stack variables

    StackT< ListT<CegoField> > _fieldListStack;
    StackT<CegoPredDesc*> _predDescStack;
    StackT<CegoAttrDesc*> _attrDescStack;
    StackT<CegoCondDesc*> _condDescStack;
    StackT<CegoHavingDesc*> _havingDescStack;
    StackT<CegoCaseCond*> _caseCondStack;
    StackT<ListT<CegoContentObject*> > _coListStack;
    StackT<ListT<CegoExpr*> > _exprListStack;
    StackT<ListT<CegoAttrDesc*>*> _groupClauseStack;
    StackT<ListT<CegoExpr*>*> _orderingClauseStack;
    StackT<CegoProcBlock*> _blockStack;
    StackT<CegoProcCond*> _condStack;
    StackT<CegoProcPred*> _predStack;
    StackT<CegoTerm*> _termStack;
    StackT<CegoFactor*> _factorStack;
    StackT<CegoExpr*> _exprStack;
    StackT<CegoFunction*> _functionStack;
    StackT<CegoSelect*> _unionStack;
    StackT<ListT<CegoProcCond*>* > _condListStack;
    StackT<ListT<CegoProcBlock*>* > _ifBlockListStack;
    StackT<CegoComparison> _compStack;
    StackT<bool> _distinctStack;
    StackT<int> _limitStack;

    CegoOrderNode::Ordering _orderingOpt;
    
    StackT<ListT<CegoOrderNode::Ordering>*> _orderingOptStack;

    StackT<Chain> _objNameStack;
    StackT<Chain> _objTableSetStack;

    CegoCaseCond *_pCaseCond;
    CegoSelect *_pSelect;
    
    bool _isUnique;
    bool _isBTree;

    bool _initialAssignment;
    bool _ifExistsOpt;

    CegoDbHandler* _pDbHandle;

    Chain _tableSet;
    Chain _defTableSet;
    Chain _updDelAlias;

    // procedure declarations

    CegoProcBlock *_pBlock;
    Chain _procName;
    Chain _procTableSet;
    
    CegoDataType _returnType;
    int _returnTypeLen;
    CegoProcedure::ProcType _procType;
    
    CegoProcedure* _pProc;
    CegoQuery *_pQuery;
    
    CegoProcBlock* _pMasterBlock;

    bool _procContext;
    bool _isNullable;
    bool _distinctOpt;
    bool _distinctAgg;
    
    Chain _dateFormat;
    Chain _dateValue;

    Chain _intString;
    Chain _floatString;

    Chain _counterName;

    CegoException _exception;
    
    CegoDbThreadPool* _pDbPool;

    unsigned long _modId;
};

#endif
