#ifndef _CEGOADMACTION_H_INCLUDED_
#define _CEGOADMACTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmAction.h  
// ---------------
// Cego semantic adm actions interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdmAction
// 
// Description: All administration actions are parsed using a dedicated admin parser. This class implements
//              all required semnatic action for the admin parser. 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoAdm.h"
#include "CegoAdminHandler.h"
#include "CegoDefs.h"

class CegoAdmAction : public CegoAdm {
    
public:

    enum ResultMode { VERBOSE, NORMAL, QUIET };

    CegoAdmAction(CegoAdminHandler *pAH, CegoModule *pModule, ResultMode resultMode, bool rawMode);
    ~CegoAdmAction();

    void setCommandChain(char* pC);
    char nextChar();
    void backChar();

    void setPitFormat(const Chain& pitFormat);
    void setDefault();

    void printTokenList();
    void statementAction();

    void rawModeOn();
    void rawModeOff();
    bool getRawMode();

    void lockInfoAction();
    void lockStatAction();
    void poolInfoAction();
    void poolEntryListAction();
    void listTableSetAction();
    void tableSetInfoAction();
    void dataFileInfoAction();
    void archLogInfoAction();
    void logInfoAction();
    void objInfoAction();
    void transactionInfoAction(); 
    void threadInfoAction();
    void dbThreadInfoAction();    
    void dbThreadLastQueryAction();    
    void admThreadInfoAction();
    void logThreadInfoAction();
    void copyInfoAction();

    void buFileInfoAction();
    void buStatInfoAction();
    void buStatResetAction();
    void keepTicketAction();
    void syncCmdAction();
    void timeoutAction();
    void nologAction();
    void msgAction();
    void cleanupAction();
    void forceloadAction();
    void xmlModeAction();
    void binModeAction();
    void plainModeAction();

    void dbSessionInfoAction();
    void listNodeAction();

    void startTableSetAction();
    void stopTableSetAction();

    void retrieveTableSetAction();
    void defineTableSetAction();
    void dropTableSetAction();
    void removeTableSetAction();
    void resetTableSetAction();
    void createTableSetAction();
    void switchTableSetAction();
    void copyTableSetAction();

    void recoverTableSetAction();
    void setLogMngAction();
    void showLogMngAction();
    void setTSInitFileAction();
    void setCheckpointAction();

    void setTSSysSizeAction();
    void setTSTmpSizeAction();
    void setTSAppSizeAction();
    void setTSRootPathAction();

    void setTSTicketAction();
    void setTSLogNumAction();
    void setTSLogSizeAction();
    void setTSSortAreaSizeAction();

    void switchSecondaryAction();
    void switchMediatorAction();

    void relocateSecondaryAction();
    void relocateMediatorAction();

    void checkTableSetAction();
    void verifyTableSetAction();
    void correctTableSetAction();

    void beginBackupAction();
    void endBackupAction();

    void syncTableSetAction();

    void getDbSpecAction();

    void getNodeListAction();
    void getDbInfoAction();

    void setTableSetNodeAction();

    void copyFileAction();

    void exportTableAction();
    void exportTableSetAction();
    void exportTableSetStructureAction();

    void importTableAction();
    void importTableSetAction();
    void importTableSetStructureAction();

    void addDataFileAction();

    void listUserAction();
    void addUserAction();
    void removeUserAction();
    void changePwdAction();    
    void assignRoleAction();
    void removeRoleAction();

    void listRoleAction();
    void showRoleAction();
    void createRoleAction();
    void dropRoleAction();
    void setPermAction();

    void setTableSetPerm();
    void setFilterPerm();
    void setRightPerm();

    void removePermAction();

    void traceOnAction();
    void traceOffAction();

    void abortDbThreadAction();

    void addArchLogAction();
    void removeArchLogAction();

    void enableArchLogAction();
    void disableArchLogAction();

    void enableAutoCorrectAction();
    void disableAutoCorrectAction();

    void enableTableCacheAction();
    void disableTableCacheAction();

    void enableQueryCacheAction();
    void disableQueryCacheAction();

    void listQueryCacheAction();
    void cleanQueryCacheAction();
    void setQueryCacheEntryAction();
    void setQueryCacheSizeAction();

    void listTableCacheAction();
    void cleanTableCacheAction();
    void setTableCacheEntryAction();
    void setTableCacheSizeAction();

    void storePrimaryAttr();
    void storeSecondaryAttr();
    void storeSysSizeAttr();
    void storeTmpSizeAttr();
    void storeLogSizeAttr();
    void storeAppSizeAttr();
    void storeLogNumAttr();
    void storeSortAreaAttr();
    void storeTSRootAttr();

    void storePit();

    void dumpTable();
    void dumpUIndex();

    void cleanUp();

private:

    void handleMedResult(CegoAdminHandler::ResultType res);

    int _i;
    char *_pC;

    int _stringBufLen;
    char _stringBuf[MAXSTRINGLEN];

    CegoModule *_pModule;
    CegoAdminHandler* _pAH;

    Chain _tsRoot;
    Chain _primary;
    Chain _secondary;

    int _sysSize;
    int _tmpSize;
    int _appSize;

    int _logSize;
    int _logNum;
    unsigned long long _sortAreaSize;
    Chain _pit;

    bool _rawMode;
    ResultMode _resultMode;

    Chain _syncCmd;
    bool _keepTicket;
    int _timeout;
    bool _doLogging;
    bool _doCleanup;
    bool _doForceload;
    Chain _xportMode;

    Chain _buMsg;

    Chain _tsPerm;
    Chain _filterPerm;
    Chain _rightPerm;

    unsigned long _modId;

    ListT<CegoField> _admSchema;
};

#endif














